"""
Created on Wed Sept 25 16:03:29 2019
@author: Jia
"""

import numpy as np
import serial
from queue import Queue

class MySerialPort(object):
    # ,pixStyle, width=45
    def __init__(self, serialPort, baudRate):
        """
        init serial port parameter
        serialPort = "COMxx" default
        baudRate = 115200 default
        """
        self.serialPort = serialPort
        self.baudRate = baudRate
        self.OpenSerialPort()
        self.StartRcvRssi = False
        self.deviceNum = 0
        self.serial_error = False
        self.RSSI = []
        self.recv_cnt = 0
        self._thread_running = False
        # self.d = FrameData(pixStyle, width, 1)

    def OpenSerialPort(self):
        try:
            self.myser = serial.Serial(self.serialPort, self.baudRate, timeout=0.5)
            print("Open %s success, baudRate = %d" % (self.serialPort, self.baudRate))
            self.serial_error = False
            self.busy = False

        except:
            self.serial_error = True
            print("Open %s failed" % self.serialPort)

    def is_number(self, s):
        try:
            float(s)
            return True
        except ValueError:
            pass
        try:
            import unicodedata
            unicodedata.numeric(s)
            return True
        except (TypeError, ValueError):
            pass
        return False

    def SerialThread_Run(self, queue: Queue, anchor_name, filter_on_pc):
        self._thread_running = True
        self.recv_cnt = 0
        # send a com port command to device
        self.myser.write('start'.encode())
        while self._thread_running is True:
            count = self.myser.inWaiting()
            if count != 0:
                recv = self.myser.readline().decode()
                # print(recv)
                if recv.startswith('\rRSSI'):
                    # if len(recv) < 13:
                    #     continue
                    self.deviceNum = recv[5]
                    temp1 = []
                    rssi = recv.split('.')[0].split(' ')[1]
                    if not self.is_number(rssi):
                        continue
                    if filter_on_pc is True:
                        self.RSSI.append(int(rssi))
                        self.recv_cnt += 1
                        if self.recv_cnt >= 30:
                            self.recv_cnt = 0
                            avg = np.mean(self.RSSI)
                            var = np.var(self.RSSI)
                            if (var * 2) < 1:
                                avg = round(avg)
                            for i in range(len(self.RSSI)):
                                if (avg + var) > self.RSSI[i] > (avg - var):
                                    temp1.append(self.RSSI[i])

                            rssi_filter = (np.mean(temp1) + np.median(temp1)) / 2
                            deb_print = self.deviceNum + ':' + str(rssi_filter)
                            print(deb_print)
                            rssi_value = str(anchor_name) + ':' + str(rssi_filter)
                            queue.put(rssi_value)
                            del self.RSSI[:]
                            del temp1[:]
                    else:
                        rssi_filter = int(rssi)
                        deb_print = self.deviceNum + ':' + str(rssi_filter)
                        # just for test, print received RSSI value
                        print(deb_print)
                        rssi_value = str(anchor_name) + ':' + str(rssi_filter)
                        queue.put(rssi_value)

        # send a com port command to device when thread end
        self.myser.write('stop'.encode())

    def terminate_thread(self):
        self._thread_running = False
